//***************************************************************************
//
//  SRCENTBN.H
//
//  Header File for Application Programming Interface for
//  SRC Enterprises Button Custom Control (SRCENTBN.DLL)
//
//  Copyright (c) 1996 Steven R Clabaugh
//
//***************************************************************************
#ifndef _INCL_SRCENTBN_H
#define _INCL_SRCENTBN_H

//**************************************************************
// Button Custom Control Types
//**************************************************************

// Momentary Pushbutton; User defined bitmaps (Default Button Type)
// that requires 2 bitmaps
//    A bitmap for the unpushed state
//    A bitmap for the pushed state
//    An optional bitmap for the disabled state
#define BTN_MNTRY     0x0000

// Predefined bitmap Spin Buttons; No bitmaps requirements from user.
#define BTN_SPIN1     0x0001   // Spin Button w/Predefined size 1 Bitmaps
#define BTN_SPIN2     0x0002   // Spin Button w/Predefined size 2 Bitmaps
#define BTN_SPIN3     0x0003   // Spin Button w/Predefined size 3 Bitmaps
#define BTN_SPIN4     0x0004   // Spin Button w/Predefined size 4 Bitmaps
#define BTN_SPIN5     0x0005   // Spin Button w/Predefined size 5 Bitmaps
#define BTN_SPIN6     0x0006   // Spin Button w/Predefined size 6 Bitmaps

// User defined bitmap Spin Button that requires 3 bitmaps.
//    A bitmap for normal unpushed state.
//    A bitmap for the incrementing pushed state.
//    A bitmap for the decrementing pushed state.
//    An optional bitmap for the disabled state
#define BTN_SPINU     0x0007   // User Defined Bitmap Spin Button

// Wrap on/off style bit for Spin Buttons
#define BTN_WRAP      0x0008   // Wrap Bit; Valid for Spin Button Only

// Color Buttons, No bitmap requirement for Color Buttons
#define BTN_RED       0x0010   // Red Color Button
#define BTN_GRN       0x0020   // Green Color Button
#define BTN_BLU       0x0030   // Blue Color Button
#define BTN_YEL       0x0040   // Yellow Color Button
#define BTN_CYN       0x0050   // Cyan Color Button
#define BTN_MAG       0x0060   // Magenta(Purple) Color Button
#define BTN_GRY       0x0070   // Gray  Color Button
#define BTN_BLK       0x0080   // Black Color Button

// Push Type 2-State Button that requires 3 bitmaps
//    A bitmap for the unpushed state 1
//    A bitmap for the unpushed state 2
//    A bitmap for the pushed state
//    An optional bitmap for the disabled state
#define BTN_P2S       0x0100   // Push Style 2-State Button

// Toggle Type 2-State Button that requires 2 bitmaps
//    A bitmap for the state 1 position
//    A bitmap for the state 2 position
//    An optional bitmap for the disabled state 1 position
//    An optional bitmap for the disabled state 2 position
#define BTN_T2S       0x0200   // Toggle Style 2-State Button

// Vertical Style Bit (Default is Horizontal)
// Valid for Spin Buttons and 2-State Toggle Buttons
#define BTN_VERT      0x0400

//**********************************************************
// Button Custom Control API Functions
//**********************************************************
#ifdef __cplusplus
extern "C" {
#endif  // __cplusplus

HWND FAR PASCAL _export SRCEntBNCreate(DWORD, LPSTR, LPSTR, LPSTR, LPSTR,
                                       int, int, int, int, int, int, int,
                                       int, int, int, BOOL, HWND, HMENU,
                                       HINSTANCE);
VOID FAR PASCAL _export SRCEntBNEnable(HWND, BOOL);
int  FAR PASCAL _export SRCEntBNGetDelay(HWND);
VOID FAR PASCAL _export SRCEntBNGetRange(HWND, LPINT, LPINT);
int  FAR PASCAL _export SRCEntBNGetSpeed(HWND);
int  FAR PASCAL _export SRCEntBNGetStep(HWND);
int  FAR PASCAL _export SRCEntBNGetVal(HWND);
VOID FAR PASCAL _export SRCEntBNInit(HWND, LPSTR, LPSTR, LPSTR, LPSTR,
                                     int, int ,int, int, int, int, BOOL);
int  FAR PASCAL _export SRCEntBNSetDelay(HWND, int);
VOID FAR PASCAL _export SRCEntBNSetHand(HWND, BOOL);
VOID FAR PASCAL _export SRCEntBNSetRange(HWND, int, int);
int  FAR PASCAL _export SRCEntBNSetSpeed(HWND, int);
int  FAR PASCAL _export SRCEntBNSetStep(HWND, int);
int  FAR PASCAL _export SRCEntBNSetVal(HWND, int);
VOID FAR PASCAL _export SRCEntBNSetWrap(HWND, BOOL);
VOID FAR PASCAL _export SRCEntBNStop(HWND);

#ifdef __cplusplus
}
#endif  // __cplusplus

//***************************************************************************
//***************************************************************************
//***************************************************************************
//
//  SRCEntBN Class Definition
//
//***************************************************************************
//***************************************************************************
//***************************************************************************
#ifdef __cplusplus

class FAR CSRCEntBN
{

   //******************************************************************
   //***********************  Member Data  ****************************
   //******************************************************************

   private:

      HWND m_hButton;

   //******************************************************************
   //***********************  Member Functions  ***********************
   //******************************************************************

   public:

      // Constructor/Destructor
      FAR PASCAL _export CSRCEntBN();
      FAR PASCAL _export ~CSRCEntBN();

      // Creates a Button (DO NOT use STRICT Type Handles)
      UINT FAR PASCAL _export Create(
                  DWORD Style,
                  LPSTR BM1,
                  LPSTR BM2,
                  LPSTR BM3,
                  LPSTR BM4,
                  int   X,
                  int   Y,
                  int   nWidth,
                  int   nHeight,
                  int   nstep,
                  int   rmin,
                  int   rmax,
                  int   val,
                  int   delay,
                  int   speed,
                  int   bHand,
                  UINT  hParent,    //Cast this to UINT in application code
                  UINT  IDVal,      //Cast this to UINT in application code
                  UINT  hInst       //Cast this to UINT in application code
                 );

      UINT FAR PASCAL _export GetHandle();
      void FAR PASCAL _export Enable(BOOL bEnable);
      int  FAR PASCAL _export GetDelay();
      void FAR PASCAL _export GetRange(LPINT lpMin, LPINT lpMax);
      int  FAR PASCAL _export GetSpeed();
      int  FAR PASCAL _export GetStep();
      int  FAR PASCAL _export GetVal();
      int  FAR PASCAL _export SetDelay(int nDelay);
      void FAR PASCAL _export SetHand(BOOL bHand);
      void FAR PASCAL _export SetRange(int nMin, int nMax);
      int  FAR PASCAL _export SetSpeed(int nSpeed);
      int  FAR PASCAL _export SetStep(int nStep);
      int  FAR PASCAL _export SetVal(int nVal);
      void FAR PASCAL _export SetWrap(int nWrap);
      void FAR PASCAL _export Stop();

}; // End CSRCEntBN Button Custom Control Class Definition

#endif // __cplusplus
#endif // _INCL_SRCENTBN_H
